<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* OES_Display
*/
class OES_Display
{
	public $CI;

	public function __construct()
	{
		$this->CI =& get_instance();
	}

	public function RenderTemplate (){
		/**
		 * If Request is AJAX, Do not render the template.
		 */
		if($this->CI->input->is_ajax_request())
		{
			return false;
		}

		if($this->CI->uri->segment(1) == 'online_exam'){
			echo $this->CI->output->get_output();
			return;
		}


		$this->CI->data['title'] = $this->getPageTitle()." | Online Examination";
		$this->CI->data['menu'] = $this->CI->menu->getMainMenu();
        $this->CI->data['page_sections'] = $this->CI->menu->getPageSections();
        $this->CI->data['sideNavPages'] = $this->CI->menu->getSideNav();

		$output = $this->CI->load->view('templates/header',$this->CI->data,TRUE);
		$output .= $this->CI->load->view('templates/main-menu',$this->CI->data, TRUE);
		$output .= 	'<div class="container">'.
					'	<div class="row">'.
					'		<div class="col-md-12">'.
					$this->CI->load->view('templates/breadcrumbs',$this->CI->data,TRUE);
		$output .= $this->CI->load->view('templates/alert-message',$this->CI->data, TRUE);
		if(isset($this->CI->data['page_name'])){
			$output .= 	'<h3 class="page-header">'.$this->CI->data['page_name'].'</h3>';
		}
		$output .= 	'<div class="row">';
		if(!empty($this->CI->data['sideNavPages']) && is_array($this->CI->data['sideNavPages']))
		{
			$output .= '	<div class="col-md-3">'.
						$this->CI->load->view('templates/side-nav', $this->CI->data, TRUE).
						'	</div>'.
						'	<div class="col-md-9">'.
						$this->CI->load->view('templates/page-sections', $this->CI->data, TRUE).
						'	</div>'.
						'	<div class="col-md-9">';
		} else {
			$output .= '	<div class="col-md-12">'.
						$this->CI->load->view('templates/page-sections', $this->CI->data, TRUE).
						'	</div>'.
						'	<div class="col-md-12">';
		}
		$output .= $this->CI->output->get_output();
		$output .= 	'				</div>'.
					'			</div>'.
					'		</div>'.
					'	</div>'.
					'</div>';
		$output .= $this->CI->load->view('templates/footer',$this->CI->data,TRUE);

		echo $output;
	}

	public function getPageTitle()
	{
		if(isset($this->CI->data['title'])) {
			return $this->CI->data['title'];
		}
		return $this->CI->db->get_where('page',array('page_url'=>current_page_url()))->row()->page_label;
	}
}
?>